---
layout: default
published: true
title: SCA scanning
nav_order: 20
---

# SCA scanning
Checkov is an SCA (Software Composition Analysis) tool. This means it scans package files and container images for Common Vulnerabilities and Exposures (CVEs).

You can find the full list of the supported package manager types [here](https://docs.prismacloud.io/en/enterprise-edition/content-collections/application-security/risk-management/monitor-and-manage-code-build/software-composition-analysis/supported-package-managers).

In order to use this feature, you first need to create an [API token using Prisma Cloud](https://docs.prismacloud.io/en/enterprise-edition/content-collections/application-security/get-started/connect-code-and-build-providers/ci-cd-runs/add-checkov), and make sure you have an internet connection.

## Package scanning
```bash
checkov -d . --framework sca_package --bc-api-key <access key>::<secret key> --prisma-api-url <prisma api url> --repo-id <repo/name>
```

### Example output
```bash
       _               _              
   ___| |__   ___  ___| | _______   __
  / __| '_ \ / _ \/ __| |/ / _ \ \ / /
 | (__| | | |  __/ (__|   < (_) \ V / 
  \___|_| |_|\___|\___|_|\_\___/ \_/  
                                      
By Prisma Cloud | version: x.x.x 


sca_package scan results:

Found CVEs: 35, Skipped CVEs: 0

	/package-lock.json
	┌────────────────────┬────────────────────┬────────────────────┬────────────────────┬────────────────────┬────────────────────┐
	│ Total CVEs: 35     │ critical: 3        │ high: 19           │ medium: 10         │ low: 3             │ skipped: 0         │
	├────────────────────┴────────────────────┴────────────────────┴────────────────────┴────────────────────┴────────────────────┤
	│ To fix 34/35 CVEs, go to Prisma Cloud                                                                                       │
	├────────────────────┬────────────────────┬────────────────────┬────────────────────┬────────────────────┬────────────────────┤
	│ Package            │ CVE ID             │ Severity           │ Current version    │ Fixed version      │ Compliant version  │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ trim-newlines      │ CVE-2021-33623     │ high               │ 1.0.0              │ 3.0.1              │ 3.0.1              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ bson               │ CVE-2020-7610      │ high               │ 1.0.9              │ 1.1.4              │ 1.1.4              │
	│                    │ CVE-2019-2391      │ medium             │                    │ 1.1.4              │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ ramda              │ PRISMA-2021-0154   │ medium             │ 0.24.1             │ N/A                │ None               │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ growl              │ CVE-2017-16042     │ critical           │ 1.9.2              │ 1.10.0             │ 1.10.0             │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ npm                │ CVE-2019-16775     │ high               │ 3.10.10            │ 6.13.3             │ 6.14.6             │
	│                    │ CVE-2019-16777     │ low                │                    │ 6.13.4             │                    │
	│                    │ CVE-2019-16776     │ low                │                    │ 6.13.3             │                    │
	│                    │ CVE-2020-15095     │ low                │                    │ 6.14.6             │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ adm-zip            │ PRISMA-2021-0034   │ high               │ 0.4.4              │ 0.5.3              │ 0.5.3              │
	│                    │ CVE-2018-1002204   │ high               │                    │ 0.4.11             │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ mongodb            │ GHSA-              │ high               │ 2.2.36             │ 3.1.13             │ 3.1.13             │
	│                    │ MH5C-679W-HH4R     │                    │                    │                    │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ minimist           │ CVE-2021-44906     │ critical           │ 0.0.10             │ 1.2.6              │ 1.2.6              │
	│                    │ CVE-2020-7598      │ medium             │                    │ 0.2.1              │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ hawk               │ CVE-2022-29167     │ high               │ 3.1.3              │ 9.0.1              │ 9.0.1              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ uglify-js          │ CVE-2015-8858      │ high               │ 2.4.24             │ 2.6.0              │ 3.14.3             │
	│                    │ PRISMA-2021-0169   │ medium             │                    │ 3.14.3             │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ tap-mocha-reporter │ PRISMA-2022-0098   │ high               │ 2.0.1              │ 5.0.2              │ 5.0.2              │
	│                    │ PRISMA-2022-0097   │ medium             │                    │ 5.0.2              │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ shelljs            │ CVE-2022-0144      │ high               │ 0.3.0              │ 0.8.5              │ 0.8.5              │
	│                    │ GHSA-64G7-MVW6-V9Q │ medium             │                    │ 0.8.5              │                    │
	│                    │ J                  │                    │                    │                    │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ cypress            │ PRISMA-2021-0070   │ medium             │ 3.8.3              │ 7.2.0              │ 7.2.0              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ helmet-csp         │ GHSA-C3M8-X3CG-    │ medium             │ 1.2.2              │ 2.9.1              │ 2.9.1              │
	│                    │ QM2C               │                    │                    │                    │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ marked             │ CVE-2022-21680     │ high               │ 0.3.9              │ 4.0.10             │ 4.0.10             │
	│                    │ CVE-2022-21681     │ high               │                    │ 4.0.10             │                    │
	│                    │ PRISMA-2021-0013   │ medium             │                    │ 1.1.1              │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ cryptiles          │ CVE-2018-1000620   │ critical           │ 2.0.5              │ 4.1.2              │ 4.1.2              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ glob-parent        │ CVE-2020-28469     │ high               │ 3.1.0              │ 5.1.2              │ 5.1.2              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ bl                 │ CVE-2020-8244      │ high               │ 1.0.3              │ 1.2.3              │ 1.2.3              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ diff               │ GHSA-H6CH-V84P-W6P │ high               │ 1.4.0              │ 3.5.0              │ 3.5.0              │
	│                    │ 9                  │                    │                    │                    │                    │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ unset-value        │ PRISMA-2022-0049   │ high               │ 1.0.0              │ 2.0.1              │ 2.0.1              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ grunt              │ CVE-2022-1537      │ high               │ 1.5.2              │ 1.5.3              │ 1.5.3              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ nconf              │ CVE-2022-21803     │ high               │ 0.10.0             │ 0.11.4             │ 0.11.4             │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ hoek               │ CVE-2018-3728      │ medium             │ 2.16.3             │ 4.2.1              │ 4.2.1              │
	├────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┼────────────────────┤
	│ moment             │ CVE-2022-24785     │ high               │ 2.24.0             │ 2.29.2             │ 2.29.2             │
	└────────────────────┴────────────────────┴────────────────────┴────────────────────┴────────────────────┴────────────────────┘
```
